/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.table;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.table.StatusTableCellBean;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.cell.AWCell;
import com.ibm.psw.wcl.core.cell.CellInfo;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.core.renderer.output.html.HTMLDocumentFragmentWrapper;
import com.ibm.psw.wcl.core.resource.UrlResource;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.renderers.cell.html.HTMLDefaultCellRenderer;
import com.ibm.psw.wcl.skins.base.BaseCellStyleInfo;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDivElement;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLImageElement;

public class SystemStatusTableCellRenderer
extends HTMLDefaultCellRenderer {
    private static final String TRACEMASK_T = "XPTRTCRT";
    private static final String TRACEMASK_F = "XPTRTCRF";
    private static final String TRACEMASK_D = "XPTRTCRD";

    public IOutput renderCell(RenderingContext rc, AWCell cell, CellInfo info) throws RendererException {
        String url;
        Trace.trace(TRACEMASK_D, "-> SystemStatusTableCellRenderer.renderCell()");
        StatusTableCellBean cellBean = (StatusTableCellBean)info.getValue();
        AStyleInfo style = cell.getStyleInfo(rc.getSkin());
        if (style == null) {
            style = new BaseCellStyleInfo();
            cell.setStyleInfo(style);
        }
        cell.setStyleInfo(style);
        HTMLDocumentFragmentWrapper doc = rc.getDocumentFactory().createHTMLDocumentFragmentWrapper();
        HTMLDivElement div = doc.createDIVElement();
        HTMLElement span = doc.createSPANElement();
        HTMLImageElement image = doc.createIMGElement();
        div.setAttribute("style", "font-size:smaller");
        String altText = null;
        if (!cellBean.isAcceptable()) {
            url = "/images/ui/bonsai/error_red_16.gif";
            altText = "Unacceptable";
        } else if (cellBean.hasAttentions()) {
            url = "/images/ui/bonsai/warning_orange_16.gif";
            altText = "Attentions";
        } else {
            url = "/images/ui/bonsai/normal_green_16.gif";
            altText = "Acceptable";
        }
        image.setSrc(new UrlResource(url).getURL(rc));
        image.setAlt(altText);
        image.setWidth("16");
        image.setHeight("16");
        span.appendChild(image);
        span.appendChild(doc.createTextNode(" " + cellBean.getText()));
        div.appendChild(span);
        doc.appendToContentFragment((Node)div);
        return doc.createOutput(rc);
    }
}

